<?php $this->app->extend('template/mahasiswa') ?>

<?php $this->app->setVar('title', 'Seminar') ?>

<?php
 $url_cetak = base_url('admin/report2');
?> 

<?php $this->app->section() ?>
<div class="card">
	<form id="edit">
		<div class="card-header">
			<div class="card-title">Detail Seminar</div>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-hover">
					

					<div class="col-md-7">
                            <div class="form-group">
                                <label>Judul Proposal</label>
								<textarea readonly name="proposal_mahasiswa_judul" rows="3" class="form-control" placeholder=""></textarea>
                            </div>
                    </div>	


					<tr>
						<td>Mahasiswa</td>
						<th class="mahasiswa_nama">-</th>
					</tr>
					<tr>
						<td>Dosen Penguji</td>
						<th class="dosen_penguji">-</th>
					</tr>
				

                    <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Tanggal</label>
                                <input type="date" name="tanggal" class="form-control">
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Jam</label>
                                <input type="time" name="jam" class="form-control">
                            </div>
                        </div>
                    </div>

					
					<div class="col-md-7">
                            <div class="form-group">
                                <label>Tempat</label>
								<textarea name="tempat" rows="3" class="form-control" placeholder="Masukkan Tempat Seminar"></textarea>
                            </div>
                    </div>						


					<tr>
						<td>Form 3A - Setelah mendapatkan Penguji</td>
						<th class="file_3A2a"></th>
						<th class="file_3A2"></th>
					</tr>

				
				</table>

				<input type="hidden" name="file_3A1">
				<input type="hidden" name="file_3A2">

				<input type="hidden" name="dosen3">

				<input type="hidden" name="email">
				<input type="hidden" name="def_status">
			</div>
		</div>
		<div class="card-footer text-right">
			<a href="<?= base_url() ?>mahasiswa/seminarku" class="btn btn-default">Kembali</a>
			<button type="submit" class="btn btn-primary btn-act">Simpan</button>
		</div>
	</form>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
	var seminar_id = '<?= $seminar_id ?>'

	$(document).ready(function() {

		function show() {
			call('api/seminar/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'mahasiswa/seminar';
					})
				} else {

					//$('.proposal_mahasiswa_judul').html(res.data.proposal_mahasiswa_judul);
					
					$('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);	


					$('.mahasiswa_nama').html(res.data.mahasiswa_nama);

					$('.dosen_penguji').html(res.data.dosen_penguji);

					$('.tanggal_jam').html(res.data.tanggal + ' ' + res.data.jam);
					$('.tempat').html(res.data.tempat);
					$('.persetujuan').html(`<a href="` + base_url + `cdn/vendor/persetujuan/` + res.data.persetujuan + `">` + res.data.persetujuan + `</a>`);
					$('.file_proposal').html(`<a href="` + base_url + `cdn/vendor/file_proposal/` + res.data.file_proposal + `">` + res.data.file_proposal + `</a>`);
					$('.sk_tim').html(`<a href="` + base_url + `cdn/vendor/sk_tim/` + res.data.sk_tim + `">` + res.data.sk_tim + `</a>`);

					$('.file_3A1a').html(`<a href="` + base_url + `cdn/vendor/file_3A1/` + res.data.file_3A1 + `" target="_blank">` + res.data.file_3A1 + `</a>`);
					$('.file_3A2a').html(`<a href="` + base_url + `cdn/vendor/file_3A2/` + res.data.file_3A2 + `" target="_blank">` + res.data.file_3A2 + `</a>`);

					$('.file_3A1').html(('') ? `<a href="` + base_url + `cdn/vendor/file_3A1/` + '' + `">` + '' + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-file_3A1">');
					$('.file_3A2').html(('') ? `<a href="` + base_url + `cdn/vendor/file_3A2/` + '' + `">` + '' + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-file_3A2">');
					
					$('[name=tanggal]').val(res.data.tanggal);
					$('[name=jam]').val(res.data.jam);

					$('[name=tempat]').val(res.data.tempat);
					$('[name=dosen3]').val(res.data.dosen3);

					
					$('[name=status]').val(res.data.hasil.status);
					
					$('[name=email]').val(res.data.email);
					$('[name=def_status]').val(res.data.hasil.status);
				}
			})
		}

		show()



		$(document).on('change', '[name=pilih-file_3A1]', function() {
			read('[name=pilih-file_3A1]', function(data) {
				$('[name=file_3A1]').val(data.result);
			})
		})

		$(document).on('change', '[name=pilih-file_3A2]', function() {
			read('[name=pilih-file_3A2]', function(data) {
				$('[name=file_3A2]').val(data.result);
			})
		})		


		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/seminar/edit2/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})

	})
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>