<?php $this->app->extend('template/mahasiswa') ?>

<?php $this->app->setVar('title', 'Penelitian') ?>

<?php $this->app->section() ?>
<div class="card">
	<div class="card-header">
		<div class="card-title">Detail Penelitian</div>
	</div>
	<form id="edit">
		<div class="card-body">
			<input type="hidden" name="persetujuan">
			<div class="table-responsive">
				<table class="table table-hover">
					<tr>
						<td>Proposal yang di Revisi</td>
						<th class="proposal_mahasiswa_judul">-</th>
					</tr>
					<tr>
						<td>Form 8A (Revisi Proposal)</td>
						<th class="bukti">-</th>
					</tr>
					<input type="hidden" name="status">
				</table>
			</div>
		</div>
		<div class="card-footer text-right">
			<a href="<?= base_url() ?>mahasiswa/revisi" class="btn btn-default">Kembali</a>
		</div>
	</form>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
	var penelitian_id = '<?= $penelitian_id ?>';
	$(document).ready(function() {

		function show() {
			call('api/revisi/details/' + penelitian_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'mahasiswa/penelitian';
					});
				} else {
					$('.proposal_mahasiswa_judul').html(res.data.proposal.judul);
					$('.bukti').html('<a href="' + base_url + 'cdn/vendor/revisi/' + res.data.bukti + '" target="_blank">' + res.data.bukti + '</a>');
					$('.status').html((res.data.hasil.status == '1') ? "Lulus" : "Belum/Tidak Lulus");
					$('[name=status]').val(res.data.hasil.status);
				}
			})
		}

		show();

		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			const data = {
				persetujuan: $('[name=persetujuan]').val(),
				status: $('[name=status]').val()
			}
			if (data.persetujuan == 'penguji') {
				data.komentar_penguji = $('[name=komentar_penguji]').val()
			} else {
				data.komentar_pembimbing = $('[name=komentar_pembimbing]').val()
			}
			call('api/hasil_penelitian/edit/' + penelitian_id, data).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
				} else {
					notif(res.message, 'success');
					show();
				}
			})
		})

	})
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>