<?php $this->app->extend('template/mahasiswa') ?>
<?php $this->app->setVar('title', 'Seminar') ?>
<?php $this->app->section() ?>

<div class="card">
    <form id="edit" enctype="multipart/form-data">

        <div class="card-header">
            <div class="card-title">Detail Seminar</div>
        </div>

        <div class="card-body">
            <div class="form-group">
                <label>Judul Proposal</label>
                <textarea readonly name="proposal_mahasiswa_judul"
                          class="form-control" rows="3"></textarea>
            </div>

            <table class="table table-bordered">
                <tr>
                    <td width="200">Mahasiswa</td>
                    <th class="mahasiswa_nama">-</th>
                </tr>
                <tr>
                    <td>Dosen Penguji</td>
                    <th class="dosen_penguji">-</th>
                </tr>
                <tr>
                    <td>Upload Form 3A (PDF)</td>
                    <td>
                        <input type="file"
                               name="file_3A2"
                               accept="application/pdf"
                               class="form-control">
                        <small class="text-muted">
                            Maksimal 50MB (PDF)
                        </small>
                    </td>
                </tr>
                <tr>
                    <td>File Saat Ini</td>
                    <td class="file_3A2a">-</td>
                </tr>
            </table>
        </div>

        <div class="card-footer text-right">
            <a href="<?= base_url('mahasiswa/proposal') ?>" class="btn btn-default">
                Kembali
            </a>
            <button type="submit" class="btn btn-primary btn-act">
                Simpan
            </button>
        </div>

    </form>
</div>

<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
var seminar_id = '<?= $seminar_id ?>';

$(document).ready(function(){

    function show(){
        call('api/proposal_mahasiswa/details/' + seminar_id).done(function(res){
            if(res.error){
                notif(res.message,'warning');
                return;
            }

            $('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);
            $('.mahasiswa_nama').html(res.data.mahasiswa_nama);
            $('.dosen_penguji').html(res.data.dosen_penguji ?? '-');

            if(res.data.file_3A2){
                $('.file_3A2a').html(
                    `<a href="<?= base_url('cdn/vendor/file_3A2/') ?>${res.data.file_3A2}" 
                        target="_blank">${res.data.file_3A2}</a>`
                );
            }else{
                $('.file_3A2a').html('-');
            }
        });
    }

    show();

$('#edit').on('submit', function(e){
    e.preventDefault();

    let fileInput = $('input[name="file_3A2"]')[0];

    if (!fileInput || fileInput.files.length === 0) {
        alert('File upload wajib diisi');
        return false;
    }

    let formData = new FormData(this);

    $(".btn-act").prop('disabled', true).text('Uploading...');

    $.ajax({
        url: "<?= base_url('api/proposal_mahasiswa/edit2/'.$seminar_id) ?>",
        type: "POST",
        data: formData,
        contentType: false,
        processData: false,
        success: function(res){
            if(res.error){
                alert(res.message);
            }else{
                alert(res.message);
                location.reload();
            }
        },
        complete: function(){
            $(".btn-act").prop('disabled', false).text('Simpan');
        }
    });
});

});
</script>
<?php $this->app->endSection('script') ?>
<?php $this->app->init() ?>
