<?php $this->app->extend('template/dosen') ?>

<?php $this->app->setVar('title', 'Ta') ?>

<?php $this->app->section() ?>
<div class="card">
    <div class="card-body">
        <div class="card-title">Cari Mahasiswa : </div>
        <form id="form_cari" action="<?= base_url('hasil-pencarian-mahasiswa'); ?>" method="POST" onsubmit="disableBtn()">
            <input type="hidden" name="level" value="Dosen">
            <select class="select2" name="id" required id="wadah_select2">

            </select>
            <button class="btn btn-primary mt-3 btn-act" type="sumbit">Lihat Selengkapnya <i class="fa fa-chevron-right"></i></button>
        </form>

    </div>
</div>
<div class="card">
    <div class="card-header">
        <div class="card-title">Data Seminar</div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="data-seminar">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>NIM</th>
                        <th>Mahasiswa</th>
                        <th>Nama Prodi</th>
                        <th>Judul Skripsi</th>
                        <th>Tanggal</th>
                        <th>Revisi Proposal</th>
                        <th>Pendaftaran sidang TA</th>
                        <th>Bukti Bimbingan</th>
                        <th>Naskah Skripsi</th>
						<th>Naskah Publikasi</th>
						<th>Bukti Tes Plagiasi</th>
						<th>Hasil Tes Plagiasi</th>
						<th>Bukti Submit Naskah Publikasi</th>
						<th>LOA</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>
<div class="modal fade" id="hapus">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="hapus">
                <div class="modal-header">
                    <div class="modal-title">Hapus Seminar</div>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <p>Anda yakin menghapus seminar terpilih ?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-primary">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<link rel="stylesheet" href="<?= base_url() ?>cdn/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<script src="<?= base_url() ?>cdn/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>cdn/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script>
    $(document).ready(function() {
        getDataSelect()
        show = () => {
            $('#data-seminar').DataTable().destroy();
            $('#data-seminar').DataTable({
                "deferRender": true,
                "ajax": {
                    "url": base_url + 'api/ta',
                    "method": "POST",
                    "dataSrc": "data"
                },
				
				
				
				
                "columns": [{
                        data: null,
                        render: function(data, typw, row, meta) {
                            return meta.row + meta.settings._iDisplayStart + 1
                        }
                    },
                    {
                        data: "nim"
                    },
                    {
                        data: "nama_mahasiswa"
                    },
                    {
                        data: "nama_prodi"
                    },
                    {
                        data: "proposal_mahasiswa_judul"
                    },
                    {
                        data: null,
                        render: function(data) {
                            return data.tanggal
                        }
                    },
                    {
                        data: "revisi",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/revisi/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "persetujuan",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/persetujuan/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "bukti_konsultasi",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/bukti_konsultasi/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "file_proposal",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/file_skripsi/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "sk_tim",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/sk_tim/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "btp",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/btp/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "htp",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/htp/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "bsnp",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/bsnp/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: "loa",
                        render: function(data) {
                            return '<a href="' + base_url + 'cdn/vendor/skripsi/loa/' + data + '" target="_blank">' + data + '</a>';
                        }
                    },
                    {
                        data: null,
                        render: function(data) {

if (data.dosen3 == '<?= $this->session->userdata('id') ?>'){

						return `
							


                        <div class="text-center">


                            <a href="` + base_url + `dosen/ta/detail/` + data.id + `" class="btn btn-sm btn-success">
                                <i class="fa fa-search"></i>
                            </a>
                        </div>`;

}else{

						return `
							


                        <div class="text-center">


                            <a href="` + base_url + `dosen/ta/pembimbing/` + data.id + `" class="btn btn-sm btn-success">
                                <i class="fa fa-search"></i>
                            </a>
                        </div>`;

}	
							

						
						
						
						
                        }
                    }
                ],
                "language": {
                    "zeroRecords": "data tidak tersedia"
                }
            })
        }

        show();

        $(document).on('click', 'button.btn-hapus', function() {
            $('form#hapus .id').val($(this).data('id'));
        })

        $(document).on('submit', 'form#hapus', function(e) {
            e.preventDefault();
            const id = $('form#hapus .id').val();
            call('api/seminar/destroy/' + id).done(function(res) {
                if (res.error == true) {
                    notif(res.message, 'error', true);
                } else {
                    notif(res.message, 'success');
                    $('div#hapus').modal('hide');
                    show();
                }
            })
        })

    })

    function getDataSelect() {
        $.ajax({
            url: base_url + 'getAllData/mahasiswa',
            dataType: 'json',
            type: 'get',
            success: function(res) {
                data = '<option value=""></option>'
                $.each(res, function(i, item) {
                    data += '<option value="' + item.id + '">(' + item.nim + ') ' + item.nama + '</option>'
                })
                $("#wadah_select2").html(data)
            }
        })
    }

    function disableBtn() {
        $(".btn-act").attr('disabled', true).html('Loading ...')
    }
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>