<?php
$rs = isset($rs) ? (object)$rs : (object)[
    'tanggal' => '',
    'jam' => '',
    'nama_mahasiswa' => '',
    'nim' => '',
    'proposal_mahasiswa_judul' => '',
    'ket' => '',
    'dosen1' => '',
    'dosen2' => '',
    'dosen3' => '',
    'masukan1' => '',
    'masukan2' => '',
    'masukan3' => '',
    'nilai1' => 0,
    'nilai2' => 0,
    'nilai3' => 0
];

function hari($tanggal) {
    $day = date('N', strtotime($tanggal));
    $hari = ['Senin','Selasa','Rabu','Kamis','Jumat','Sabtu','Minggu'];
    return $tanggal ? $hari[$day-1] : '';
}

$namahari = hari($rs->tanggal);
?>

<link rel="stylesheet" href="<?= base_url('assets/css/printing-A4-half.css') ?>" />
<title>Berita Acara</title>

<style>
    body { font-family: "Times New Roman", serif; font-size: 12px; color: #000; }
    .page { margin: 20mm; }

    /* Header */
    .header { text-align:center; padding: 15px; background-color:#2c3e50; color: #fff; border-radius:8px; }
    .header img { height: 70px; margin-bottom:10px; }
    .header h3, .header h4 { margin:0; }
    .header p { margin:0; font-size:12px; color: #ecf0f1; }

    /* Garis pemisah */
    .divider { border-bottom: 3px solid #2980b9; margin:15px 0; }

    /* Info mahasiswa */
    table.info-mahasiswa { width:100%; border-collapse: collapse; margin-bottom:20px; }
    table.info-mahasiswa td { padding:5px; }

    /* Tabel penilaian */
    table.penilaian { width:100%; border-collapse: collapse; margin-bottom:25px; }
    table.penilaian th, table.penilaian td { padding:8px; border:1px solid #999; text-align:left; }
    table.penilaian th { background-color:#3498db; color:#fff; }
    table.penilaian tbody tr:nth-child(odd) { background-color:#ecf0f1; }

    /* Signature */
    table.signature { width:100%; margin-top:50px; text-align:center; border:none; }
    table.signature td { border:none; padding-top:50px; font-weight:bold; }

    /* Footer */
    .footer { text-align:right; font-size:10px; color:#555; margin-top:20px; }
</style>

<body onload="setTimeout(()=>window.close(),300);window.print();">
<div class="page">

<!-- Header -->
<div class="header">
    <img src="<?= base_url('assets/img/logo_unmu.png') ?>" />
    <h3>FORM 5-A</h3>
    <h4>BERITA ACARA UJIAN PROPOSAL</h4>
    <p>FAKULTAS KEDOKTERAN UNIVERSITAS MUHAMMADIYAH SURABAYA</p>
</div>
<div class="divider"></div>

<!-- Info Mahasiswa -->
<p>Pada hari <b><?= $namahari ?></b>, tanggal <b><?= $rs->tanggal ? date('d F Y', strtotime($rs->tanggal)) : '-' ?></b>, telah dilaksanakan Sidang Tugas Akhir dari pukul <b><?= $rs->jam ?: '-' ?></b> WIB s/d selesai, bertempat di Ruang Sidang/Ujian Fakultas Kedokteran, atas nama mahasiswa berikut:</p>

<table class="info-mahasiswa">
    <tr><td width="20%">Nama Mahasiswa</td><td width="2%">:</td><td><?= $rs->nama_mahasiswa ?: '-' ?></td></tr>
    <tr><td>NIM</td><td>:</td><td><?= $rs->nim ?: '-' ?></td></tr>
    <tr><td>Program Studi</td><td>:</td><td>S1 Pendidikan Dokter</td></tr>
    <tr><td>Judul Tugas Akhir</td><td>:</td><td><?= $rs->proposal_mahasiswa_judul ?: '-' ?></td></tr>
    <tr><td>Dengan Hasil</td><td>:</td><td><?= $rs->ket ?: '-' ?></td></tr>
</table>

<!-- Penilaian Dosen -->
<h4>Hasil Penilaian:</h4>
<table class="penilaian">
    <thead>
        <tr>
            <th>Nama Dosen</th>
            <th>Jabatan</th>
            <th>Masukan</th>
            <th>Nilai</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?= $rs->dosen3 ?: '-' ?></td>
            <td>Penguji</td>
            <td><?= $rs->masukan3 ?: '-' ?></td>
            <td><?= $rs->nilai3 ?: 0 ?></td>
        </tr>
        <tr>
            <td><?= $rs->dosen1 ?: '-' ?></td>
            <td>Pembimbing 1</td>
            <td><?= $rs->masukan1 ?: '-' ?></td>
            <td><?= $rs->nilai1 ?: 0 ?></td>
        </tr>
        <tr>
            <td><?= $rs->dosen2 ?: '-' ?></td>
            <td>Pembimbing 2</td>
            <td><?= $rs->masukan2 ?: '-' ?></td>
            <td><?= $rs->nilai2 ?: 0 ?></td>
        </tr>
        <tr>
            <td colspan="3"><b>Total</b></td>
            <td><b><?= ($rs->nilai1 + $rs->nilai2 + $rs->nilai3) ?></b></td>
        </tr>
    </tbody>
</table>

<!-- Tanda Tangan -->
<table class="signature">
    <tr>
        <td>Pembimbing 1<br><br><br><?= $rs->dosen1 ?: '-' ?></td>
        <td>Pembimbing 2<br><br><br><?= $rs->dosen2 ?: '-' ?></td>
        <td>Penguji<br><br><br><?= $rs->dosen3 ?: '-' ?></td>
    </tr>
</table>

<div class="footer">
    Dicetak pada: <?= date('d F Y H:i') ?>
</div>

</div>
</body>
