<?php $this->app->extend('template/mahasiswa') ?>

<?php $this->app->setVar('title', 'Seminar') ?>

<?php
 $url_cetak = base_url('admin/report2');
?> 

<?php $this->app->section() ?>
<div class="card">
	<form id="edit">
		<div class="card-header">
			<div class="card-title">Detail Seminar</div>
		</div>
		<div class="card-body">
			<div class="table-responsive">
				<table class="table table-hover">
					<tr>
						<td>Proposal</td>
						<th class="proposal_mahasiswa_judul">-</th>
					</tr>
					<tr>
						<td>Mahasiswa</td>
						<th class="mahasiswa_nama">-</th>
					</tr>
					<tr>
						<td>Waktu Seminar</td>
						<th class="tanggal_jam">0000-00-00 00:00 AM</th>
					</tr>
					<tr>
						<td>Tempat</td>
						<th class="tempat">-</th>
					</tr>
					<tr>
						<td>Naskah Publikasi</td>
						<th class="persetujuan">-</th>
					</tr>
					<tr>
						<td>Naskah Proposal</td>
						<th class="file_proposal">-</th>
					</tr>
					<tr>
						<td>Pengumuman Penguji</td>
						<th class="sk_tim">-</th>
					</tr>
					<tr>
						<td>Bukti Bimbingan</td>
						<th class="bukti_konsultasi">-</th>
					</tr>
					<tr>
						<td>Berita Acara</td>
						<th>
						
							<a href="<?= base_url() ?>admin/report6/cetak/<?= $seminar_id ?>" target="_blank">CETAK Berita Acara</a>
							
						
						</th>
					</tr>
					
					<tr>
						<td>Masukan</td>
						<th class="masukan"></th>
					</tr>

					
					<tr>
						<td>a. Nilai Dosen Pembimbing 1</td>
						<th>
							<input type="text" name="nilai1">
						</th>
					</tr>					

					<tr>
						<td>b. Nilai Dosen Pembimbing 2</td>
						<th>
							<input type="text" name="nilai2">
						</th>
					</tr>		

					<tr>
						<td>c. Nilai Dosen Penguji</td>
						<th>
							<input type="text" name="nilai3">
						</th>
					</tr>
		

					<tr>
						<td>Status</td>
						<th>
							<select name="status" class="form-control">
								<option value="1">DITERIMA, tanpa Perbaikan</option>
								<option value="2">DITERIMA, dengan Perbaikan tanpa Ujian Proposal Ulang</option>
								<option value="3">DITOLAK, Melakukan Ujian Ulang tanpa Mengganti Judul</option>
								<option value="4">DITOLAK, Melakukan Ujian Ulang dengan Mengganti Judul</option>
							</select>
						</th>
					</tr>
					
					
				</table>
				<input type="hidden" name="berita_acara">
				<input type="hidden" name="masukan">
				<input type="hidden" name="email">
				<input type="hidden" name="def_status">
			</div>
		</div>
		<div class="card-footer text-right">
			<a href="<?= base_url() ?>admin/seminar" class="btn btn-default">Kembali</a>
			<button type="submit" class="btn btn-primary btn-act">Simpan</button>
		</div>
	</form>
</div>
<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<script>
	var seminar_id = '<?= $seminar_id ?>'

	$(document).ready(function() {

		function show() {
			call('api/seminar/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'mahasiswa/seminar';
					})
				} else {
					$('.proposal_mahasiswa_judul').html(res.data.proposal_mahasiswa_judul);
					$('.mahasiswa_nama').html(res.data.mahasiswa_nama);
					$('.tanggal_jam').html(res.data.tanggal + ' ' + res.data.jam);
					$('.tempat').html(res.data.tempat);
					$('.persetujuan').html(`<a href="` + base_url + `cdn/vendor/persetujuan/` + res.data.persetujuan + `">` + res.data.persetujuan + `</a>`);
					$('.file_proposal').html(`<a href="` + base_url + `cdn/vendor/file_proposal/` + res.data.file_proposal + `">` + res.data.file_proposal + `</a>`);
					$('.sk_tim').html(`<a href="` + base_url + `cdn/vendor/sk_tim/` + res.data.sk_tim + `">` + res.data.sk_tim + `</a>`);
					$('.bukti_konsultasi').html(`<a href="` + base_url + `cdn/vendor/bukti_konsultasi/` + res.data.bukti_konsultasi + `">` + res.data.bukti_konsultasi + `</a>`);
					$('.berita_acara').html((res.data.hasil.berita_acara) ? `<a href="` + base_url + `cdn/vendor/berita_acara/` + res.data.hasil.berita_acara + `">` + res.data.hasil.berita_acara + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-berita_acara">');
					$('.masukan').html((res.data.hasil.masukan) ? `<a href="` + base_url + `cdn/vendor/masukan/` + res.data.hasil.masukan + `">` + res.data.hasil.masukan + `</a>` : '<input type="file" accept="application/pdf" class="form-control" name="pilih-masukan">');
					$('[name=status]').val(res.data.hasil.status);
					$('[name=nilai1]').val(res.data.hasil.nilai1);
					$('[name=nilai2]').val(res.data.hasil.nilai2);
					$('[name=nilai3]').val(res.data.hasil.nilai3);
					$('[name=email]').val(res.data.email);
					$('[name=def_status]').val(res.data.hasil.status);
				}
			})
		}

		show()

		$(document).on('change', '[name=pilih-berita_acara]', function() {
			read('[name=pilih-berita_acara]', function(data) {
				$('[name=berita_acara]').val(data.result);
			})
		})

		$(document).on('change', '[name=pilih-masukan]', function() {
			read('[name=pilih-masukan]', function(data) {
				$('[name=masukan]').val(data.result);
			})
		})

		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/hasil_seminar/edit1/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})

	})
</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>