<?php $this->app->extend('template/admin') ?>
<?php $this->app->setVar('title', 'Seminar') ?>
<?php $this->app->section() ?>

<div class="card">
    <div class="card-body">
        <div class="card-title">Cari Mahasiswa : </div>
        <form id="form_cari" action="<?= base_url('hasil-pencarian-mahasiswa'); ?>" method="POST" onsubmit="disableBtn()">
            <input type="hidden" name="level" value="Admin">
            <select class="select2" name="id" required id="wadah_select2"> </select>
            <button class="btn btn-primary mt-3 btn-act" type="sumbit">Lihat Selengkapnya <i class="fa fa-chevron-right"></i></button>
        </form>
    </div>
</div>

<div class="card mt-3">
    <div class="card-header">
        <div class="card-title">Data Seminar</div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover" id="data-seminar">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>NIM</th>
                        <th>Mahasiswa</th>
                        <th>Tanggal</th>
                        <th>Tempat</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody></tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Hapus -->
<div class="modal fade" id="hapus">
    <div class="modal-dialog">
        <div class="modal-content">
            <form id="form-hapus">
                <div class="modal-header">
                    <h5 class="modal-title">Hapus Seminar</h5>
                </div>
                <div class="modal-body">
                    <input type="hidden" class="id">
                    <p>Anda yakin menghapus seminar ini?</p>
                </div>
                <div class="modal-footer">
                    <button class="btn btn-default" type="button" data-dismiss="modal">Batal</button>
                    <button type="submit" class="btn btn-danger">Hapus</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>
<link rel="stylesheet" href="<?= base_url() ?>cdn/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
<script src="<?= base_url() ?>cdn/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="<?= base_url() ?>cdn/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script>
$(document).ready(function() {

    // Load mahasiswa ke select2
    function getDataSelect() {
        $.getJSON(base_url + 'getAllData/mahasiswa', function(res) {
            let data = '<option value=""></option>';
            $.each(res, function(i, item) {
                data += '<option value="' + item.id + '">(' + item.nim + ') ' + item.nama + '</option>';
            });
            $("#wadah_select2").html(data);
        });
    }
    getDataSelect();

    // Disable tombol submit saat loading
    function disableBtn() {
        $(".btn-act").attr('disabled', true).html('Loading ...');
    }

    // Tampilkan DataTables
    function show() {
        $('#data-seminar').DataTable().destroy();
        $('#data-seminar').DataTable({
            "ajax": {
                "url": base_url + 'api/seminar',
                "method": "POST",
                "dataSrc": "data"
            },
            "columns": [
                {
                    data: null,
                    render: function(data, type, row, meta) {
                        return meta.row + 1;
                    }
                },
                { data: "nim" },
                { data: "nama_mahasiswa" },
                {
                    data: null,
                    render: function(data) {
                        return data.tanggal + ' ' + data.jam;
                    }
                },
                { data: "tempat" },
                {
                    data: null,
                    render: function(data) {
                        return `
                            <div class="text-center">
                                <a href="${base_url}admin/report6/cetak/${data.id}" class="btn btn-sm btn-success" target="_blank">
                                    <i class="fa fa-print"></i>
                                </a>
                                <a href="${base_url}admin/seminar/detail/${data.id}" class="btn btn-sm btn-success">
                                    <i class="fa fa-pen"></i>
                                </a>
                                <a href="${base_url}admin/seminar/admin/${data.id}/${data.mahasiswa_id}" class="btn btn-sm btn-success">
                                    <i class="fa fa-search"></i>
                                </a>
                                <button class="btn btn-danger btn-hapus btn-sm" type="button" data-toggle="modal" data-target="#hapus" data-id="${data.id}">
                                    <i class="fa fa-trash"></i>
                                </button>
                            </div>
                        `;
                    }
                }
            ],
            "language": {
                "zeroRecords": "Data tidak tersedia"
            }
        });
    }
    show();

    // Event klik tombol hapus
    $(document).on('click', 'button.btn-hapus', function() {
        $('form#form-hapus .id').val($(this).data('id'));
    });

    // Submit hapus
    $(document).on('submit', 'form#form-hapus', function(e) {
        e.preventDefault();
        const id = $('form#form-hapus .id').val();
        call('api/seminar/destroy/' + id).done(function(res) {
            if (res.error) notif(res.message, 'error', true);
            else {
                notif(res.message, 'success');
                $('#hapus').modal('hide');
                show();
            }
        });
    });

});
</script>
<?php $this->app->endSection('script') ?>
<?php $this->app->init() ?>
