<?php $this->app->extend('template/admin') ?>

<?php $this->app->setVar('title', 'Proposal') ?>

<?php $this->app->section() ?>


<?php
// Ambil session current_page, kalau tidak ada pakai default URL
$previous_page = $this->session->userdata('current_page') ?? base_url('admin/proposal');
?>


<div class="card">
	<form id="edit">
	<div class="card-header">
		<div class="card-title">Detail Proposal</div>
	</div>
	<div class="card-body">
		<div class="table-responsive">
			<table class="table table-hover">

				<div class="row">
					<div class="col-md-4">
                            <div class="form-group">
                                <label>Judul Proposal</label>
								<textarea readonly name="proposal_mahasiswa_judul" rows="3" class="form-control" placeholder=""></textarea>
                            </div>
                    </div>
					
					<div class="col-md-4">
                            <div class="form-group">
                                <label>Ringkasan</label>
								<textarea name="ringkasan" rows="3" class="form-control" placeholder="Masukkan ringkasan"></textarea>
                            </div>
                    </div>
                    
                    <div class="col-md-4">
                            <div class="form-group">
                                <label>Jenis Skripsi <span class="text-danger">*</span></label>
                                <select name="jenis_skripsi" class="form-control">
                                    <option value="">- Pilih Jenis Skripsi -</option>
                                    <option value="1">Skripsi Konvensional</option>
                                    <option value="2">Sistematik Review</option>
                                    <option value="3">Case Report</option>
                                </select>
                            </div>	
                    </div>


				</div>
				

                <div class="row">
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Pembimbing 1</label>
								<select name="dosen_id" id="dosen_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Pembimbing 2</label>
								<select name="dosen2_id" id="dosen2_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Dosen Penguji</label>
								<select name="dosen_penguji_id" id="dosen_penguji_id" class="form-control">
										<option value="">-- Pilih Dosen --</option>
										<?php foreach ($dosen as $row): ?>
											<option value="<?php echo $row->id; ?>"><?php echo $row->nama; ?></option>
										<?php endforeach; ?>
								</select>								
                            </div>
                        </div>						
                </div>


			</table>



		</div>

	</div>
		
	
	<div class="card-footer text-right">
		<a href="<?= $previous_page; ?>" class="btn btn-default">Kembali</a>
		<button type="submit" class="btn btn-primary btn-act">Simpan</button>
	</div>

	</form>

</div>


<!-- DOKUMEN -->
<div class="card mt-3">
    <div class="card-header">
        <strong>📄 Dokumen Tersimpan</strong>
    </div>
    <div class="card-body">
        <div class="row" id="dokumenTersimpan"></div>
    </div>
</div>


<?php $this->app->endSection('content') ?>

<?php $this->app->section() ?>


    <link href="<?php echo base_url(); ?>assets/dropzone/bootstrap.min.css" rel="stylesheet" type="text/css"/> 
    <link href="<?php echo base_url(); ?>assets/dropzone/dropzone.min.css" rel="stylesheet" type="text/css"/>
    <script src="<?php echo base_url(); ?>assets/dropzone/dropzone.min.js" type="text/javascript"></script>
    <script src="<?php echo base_url(); ?>assets/dropzone/jquery-3.3.1.min.js" type="text/javascript"></script>  


<script>

var seminar_id = '<?= $seminar_id ?>'


Dropzone.autoDiscover = false;

function loadDokumen(){
    $.get("<?= base_url('dropzone-upload-image/get') ?>", function(html){
        $("#dokumenTersimpan").html(html);
    });
}


function hapusFile(token){
    $.post("<?= base_url('remove_foto/post') ?>", {token:token}, function(){
        loadDokumen();
    });
}

$(document).ready(function(){
    loadDokumen(); // load awal
});

// END DROPZONE


	$(document).ready(function() {

		function show() {
			call('api/proposal_mahasiswa/details/' + seminar_id).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'warning').then(function() {
						window.location = base_url + 'admin/proposal';
					})
				} else {
					console.log(res.data)
					
					$('[name=ringkasan]').val(res.data.ringkasan);
					$('[name=proposal_mahasiswa_judul]').val(res.data.proposal_mahasiswa_judul);
                    
	                $('[name=dosen_id]').val(res.data.dosen1);
                    $('[name=dosen2_id]').val(res.data.dosen2);
					$('[name=dosen_penguji_id]').val(res.data.dosen3);

                    $('[name=jenis_skripsi]').val(res.data.jenis_skripsi);



                     



				}
			})
		}

		show()


		$(document).on('submit', 'form#edit', function(e) {
			e.preventDefault();
			$(".btn-act").attr('disabled', true).html('Loading...')
			call('api/proposal_mahasiswa/edit3/' + seminar_id, $(this).serialize()).done(function(res) {
				if (res.error == true) {
					notif(res.message, 'error', true);
					$(".btn-act").attr('disabled', false).html('Selesai')
				} else {
					notif(res.message, 'success');
					show();
					$(".btn-act").attr('disabled', false).html('Selesai')
				}
			})
		})


	})



function kirimData(nilai) {

    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>remove_foto/post",
        data: { token: nilai },
        success: function(response) {
        
		window.location.href = '<?php echo $previous_page;?>';


        }
    });
}	




</script>
<?php $this->app->endSection('script') ?>

<?php $this->app->init() ?>