<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Ta_model extends CI_Model
{

	protected $table = "skripsi";



	public function view_all(){

		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			proposal_mahasiswa_v.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');			
		
		$query = $this->db->get();
		
        return $query->result();
		
	}
	
    public function view_by_date($tgl_awal, $tgl_akhir){
        $tgl_awal = $this->db->escape($tgl_awal);
        $tgl_akhir = $this->db->escape($tgl_akhir);
		
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			proposal_mahasiswa_v.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');		
		
		
        $this->db->where('DATE(seminar.tanggal) BETWEEN '.$tgl_awal.' AND '.$tgl_akhir); // Tambahkan where tanggal nya
		
		$query = $this->db->get();
		
    return $query->result();
	}
  
  
  
  function get_all()
  {
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			proposal_mahasiswa_v.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
    $query = $this->db->get();
    return $query->result();
  }

	public function index($input)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			skripsi.id,
			skripsi.jadwal_skripsi as tanggal,
			skripsi.file_skripsi as file_proposal,
			skripsi.bukti_konsultasi,
			skripsi.persetujuan,
			skripsi.sk_tim,
			skripsi.revisi,
			skripsi.btp,
			skripsi.htp,
			skripsi.bsnp,
		    skripsi.loa,	
			
			"" as tempat,

			skripsi.dosen_id         as dosen1,
			skripsi.dosen2_id as dosen2,
			skripsi.dosen_penguji_id as dosen3,

			skripsi_v.judul_skripsi as proposal_mahasiswa_judul,
			skripsi_v.nama_mahasiswa,
			skripsi_v.nim,
			skripsi_v.nama_prodi,

			
			
			hasil_skripsi.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_skripsi', 'hasil_skripsi.seminar_id = skripsi.id', 'left');
		$this->db->join('skripsi_v', 'skripsi_v.id_skripsi = skripsi.id', 'left');

		if ($input['mahasiswa_id']) {
			$this->db->where('skripsi.mahasiswa_id', $input['mahasiswa_id']);
		}

		$seminar = $this->db->get()->result_array();

		$hasil = [
			'error' => false,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar,
		];

		return $hasil;
	}

	public function create($input)
	{
		$data = [
			'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat'],
			'file_proposal' => $input['file_proposal'],
			'sk_tim' => $input['sk_tim'],
			'persetujuan' => $input['persetujuan'],
			'bukti_konsultasi' => $input['bukti_konsultasi'],
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {
			$file_nama = date('Ymdhis') . '.pdf';

			// upload base64 file_proposal
			$file_proposal_file = explode(';base64,', $data['file_proposal'])[1];
			file_put_contents(FCPATH . 'cdn/vendor/file_proposal/' . $file_nama, base64_decode($file_proposal_file));
			$data['file_proposal'] = $file_nama;

			// upload sk_tim
			$sk_tim_file = explode(';base64,', $data['sk_tim'])[1];
			file_put_contents(FCPATH . 'cdn/vendor/sk_tim/' . $file_nama, base64_decode($sk_tim_file));
			$data['sk_tim'] = $file_nama;

			$bukti_konsultasi_file = explode(';base64,', $data['bukti_konsultasi'])[1];
			file_put_contents(FCPATH . 'cdn/vendor/bukti_konsultasi/' . $file_nama, base64_decode($bukti_konsultasi_file));
			$data['bukti_konsultasi'] = $file_nama;

			$persetujuan_file = explode(';base64,', $data['persetujuan'])[1];
			file_put_contents(FCPATH . 'cdn/vendor/persetujuan/' . $file_nama, base64_decode($persetujuan_file));
			$data['persetujuan'] = $file_nama;

			$this->db->insert($this->table, $data);
			$data_id = $this->db->insert_id();
			$this->db->insert("hasil_seminar", [
				'seminar_id' => $data_id,
				'berita_acara' => "",
				'masukan' => "",
				'status' => '3'
			]);

			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambahkan",
				'data_id' => $data_id
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}

	public function details($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			skripsi.id,
			skripsi.jadwal_skripsi as tanggal,
			"" as jam,
			"" as tempat,
			skripsi.persetujuan,
			skripsi.file_skripsi as file_proposal,
			skripsi.sk_tim,
			skripsi.bukti_konsultasi,
			skripsi.judul_skripsi as proposal_mahasiswa_judul,
			proposal_mahasiswa.dosen_id as dosen1,
			proposal_mahasiswa.dosen2_id as dosen2,
			proposal_mahasiswa.dosen_penguji_id as dosen3,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email
		');

		$this->db->from($this->table);
		$this->db->join('proposal_mahasiswa', 'proposal_mahasiswa.id = skripsi.proposal_mahasiswa_id', 'left');
		$this->db->join('mahasiswa', 'mahasiswa.id = skripsi.mahasiswa_id', 'left');
		$this->db->where('skripsi.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar
		];

		if ($hasil['data']) {
			$hasil['data']['hasil'] = $this->db->get_where('hasil_skripsi', ['seminar_id' => $hasil['data']['id']])->row_array();
		}

		return $hasil;
	}

	public function destroy($id)
	{
		$kondisi = [
			'id' => $id
		];

		$seminar = $this->db->get_where($this->table, $kondisi)->row_array();

		if ($seminar) {
			$hasil_seminar = $this->db->get_where('hasil_seminar', ['seminar_id' => $id])->result_array();
			foreach ($hasil_seminar as $key => $item) {
				if ($item['berita_acara']) {
					unlink(FCPATH . 'cdn/vendor/berita_acara/' . $item['berita_acara']);
				}
				if ($item['masukan']) {
					unlink(FCPATH . 'cdn/vendor/masukan/' . $item['masukan']);
				}
			}
			unlink(FCPATH . 'cdn/vendor/file_proposal/' . $seminar['file_proposal']);
			unlink(FCPATH . 'cdn/vendor/sk_tim/' . $seminar['sk_tim']);
			$this->db->delete("hasil_seminar", ['seminar_id' => $id]);
			$this->db->delete($this->table, $kondisi);
			$hasil = [
				'error' => false,
				'message' => "data berhasil dihapus"
			];
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}

		return $hasil;
	}
}

/* End of file Seminar_model.php */
/* Location: ./application/models/Seminar_model.php */