<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Skripsi_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Email_model', 'emailm');
    }
    protected $table = "skripsi";



public function index($input)
{
    if (!empty($input['mahasiswa_id'])) {
        $this->db->where('skripsi_vl.mahasiswa_id', $input['mahasiswa_id']);
    }

    if (!empty($input['dosen_id'])) {
        $this->db->group_start();
        $this->db->where('skripsi_vl.dosen_id', $input['dosen_id']);
        $this->db->or_where('skripsi_vl.dosen2_id', $input['dosen_id']);
        $this->db->or_where('skripsi_vl.dosen_penguji_id', $input['dosen_id']);
        $this->db->group_end();
    }

    $data = $this->db->get('skripsi_vl')->result_array();

    return [
        'error'   => false,
        'message' => $data ? 'data berhasil ditemukan' : 'data tidak tersedia',
        'data'    => $data
    ];
}



    public function admin_index($input)
    {
        $skripsi = $this->db->get('skripsi_vl')->result_array();

        $hasil = [
            'error' => false,
            'message' => ($skripsi) ? "data berhasil ditemukan" : "data tidak tersedia",
            'data' => $skripsi,
        ];

        return $hasil;
    }


    public function create($input)
    {

        $user = $this->session->userdata('id');


		$data = [
            'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
            'judul_skripsi' => $input['judul_skripsi'],
            'tempat' => $input['tempat'],
            'tanggal' => $input['tanggal'],
            'jam' => $input['jam'],
            'mahasiswa_id' => $user
        ];

        $validation = $this->app->validate($data);

        if ($validation === true) {
            $file_nama = date('Ymdhis') . '.pdf';


            if ($this->db->insert('skripsi', $data)) {
                $data_id = $this->db->insert_id();

			$this->db->insert("hasil_skripsi", [
				'seminar_id' => $data_id,
				'berita_acara' => "",
				'masukan' => "",
				'status' => '3'
			]);
			
			
                $hasil = [
                    'error' => false,
                    'message' => "data berhasil ditambahkan",
                    'data_id' => $data_id
                ];
            }
        } else {
            $hasil = $validation;
        }

        return $hasil;
    }

    public function update($input, $id)
    {
		
		
        $data = [
            'mahasiswa_id' => $input['mahasiswa_id'],
            'judul_skripsi' => $input['judul_skripsi'],
            'jadwal_skripsi' => $input['jadwal_skripsi']				
        ];

        $kondisi = ['skripsi.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi)->num_rows();

        if ($cek > 0) {
            $validate = $this->app->validate($data);
            if ($validate === true) {

                $file_nama = date('Ymdhis') . '.pdf';


                if ($input['persetujuan'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/persetujuan/' . $input['def_persetujuan']);
                    $persetujuan_file = explode(';base64,', $input['persetujuan'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/persetujuan/' . $file_nama, base64_decode($persetujuan_file));
                    $data['persetujuan'] = $file_nama;
                }
                if ($input['file_skripsi'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/file_skripsi/' . $input['def_file_skripsi']);
                    $file_skripsi_file = explode(';base64,', $input['file_skripsi'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/file_skripsi/' . $file_nama, base64_decode($file_skripsi_file));
                    $data['file_skripsi'] = $file_nama;
                }
                if ($input['sk_tim'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/sk_tim/' . $input['def_sk_tim']);
                    $sk_tim_file = explode(';base64,', $input['sk_tim'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/sk_tim/' . $file_nama, base64_decode($sk_tim_file));
                    $data['sk_tim'] = $file_nama;
                }
                if ($input['bukti_konsultasi'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/bukti_konsultasi/' . $input['def_bukti_konsultasi']);
                    $bukti_konsultasi_file = explode(';base64,', $input['bukti_konsultasi'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/bukti_konsultasi/' . $file_nama, base64_decode($bukti_konsultasi_file));
                    $data['bukti_konsultasi'] = $file_nama;
                }
				
                if ($input['revisi'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/revisi/' . $input['def_revisi']);
                    $revisi_file = explode(';base64,', $input['revisi'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/revisi/' . $file_nama, base64_decode($revisi_file));
                    $data['revisi'] = $file_nama;
                }

                if ($input['btp'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/btp/' . $input['def_btp']);
                    $btp_file = explode(';base64,', $input['btp'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/btp/' . $file_nama, base64_decode($btp_file));
                    $data['btp'] = $file_nama;
                }
				
                if ($input['htp'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/htp/' . $input['def_htp']);
                    $htp_file = explode(';base64,', $input['htp'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/htp/' . $file_nama, base64_decode($htp_file));
                    $data['htp'] = $file_nama;
                }

                if ($input['bsnp'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/bsnp/' . $input['def_bsnp']);
                    $bsnp_file = explode(';base64,', $input['bsnp'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/bsnp/' . $file_nama, base64_decode($bsnp_file));
                    $data['bsnp'] = $file_nama;
                }
				
                if ($input['loa'] != '') {
                    unlink(FCPATH . 'cdn/vendor/skripsi/loa/' . $input['def_loa']);
                    $loa_file = explode(';base64,', $input['loa'])[1];
                    file_put_contents(FCPATH . 'cdn/vendor/skripsi/loa/' . $file_nama, base64_decode($loa_file));
                    $data['loa'] = $file_nama;
                }				
				
				

                $this->db->update($this->table, $data, $kondisi);
                $hasil = [
                    'error' => false,
                    'message' => "data berhasil diedit",
                ];
            } else {
                $hasil = $validate;
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function destroy($id)
    {


 		// hapus folder file_skripsi

		$id_user	= $this->session->userdata('id');

		$kondisi = [
			'id_user' => $id_user
		];

		$hasil_foto = $this->db->get_where('foto', ['id_user' => $id_user])->result_array();

			foreach ($hasil_foto as $key => $item) {
				if ($item['nama_foto']) {
					unlink(FCPATH . 'cdn/vendor/file_skripsi/' . $item['nama_foto']);
				}
			}

		$this->db->delete("foto", ['id_user' => $id_user]);

		// end hapus folder file_skripsi

        $kondisi = [
            'id' => $id
        ];

        $skripsi = $this->db->get_where($this->table, $kondisi)->row_array();

        if ($skripsi) {
            unlink(FCPATH . 'cdn/vendor/skripsi/file_skripsi/' . $skripsi['file_skripsi']);
            unlink(FCPATH . 'cdn/vendor/skripsi/sk_tim/' . $skripsi['sk_tim']);
            unlink(FCPATH . 'cdn/vendor/skripsi/persetujuan/' . $skripsi['persetujuan']);
            unlink(FCPATH . 'cdn/vendor/skripsi/bukti_konsultasi/' . $skripsi['bukti_konsultasi']);
            unlink(FCPATH . 'cdn/vendor/skripsi/revisi/' . $skripsi['revisi']);
            unlink(FCPATH . 'cdn/vendor/skripsi/bsnp/' . $skripsi['bsnp']);
            unlink(FCPATH . 'cdn/vendor/skripsi/btp/' . $skripsi['btp']);
            unlink(FCPATH . 'cdn/vendor/skripsi/htp/' . $skripsi['htp']);
            unlink(FCPATH . 'cdn/vendor/skripsi/loa/' . $skripsi['loa']);


            $this->db->delete($this->table, $kondisi);
            $hasil = [
                'error' => false,
                'message' => "data berhasil dihapus"
            ];
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function agree($id)
    {
        $kondisi = ['skripsi.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        $email = '';
        $dskripsi = $this->db->get_where('skripsi_vl', array('id_skripsi' => $id))->result();
        foreach ($dskripsi as $ds) {
            $email = $ds->email;
        }

        if ($cek > 00) {
            if ($this->db->update($this->table, ['status' => "1"], $kondisi)) {
                $isi_email = '
                    <p>Seminar akhir / skripsi anda telah disetujui</p>
                    ';
                $this->emailm->send('Seminar Akhir Disetujui', $email, $isi_email);

                $hasil = [
                    'error' => false,
                    'message' => "skripsi berhasil disetujui"
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function disagree($id)
    {
        $kondisi = ['skripsi.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        $email = '';
        $dskripsi = $this->db->get_where('skripsi_vl', array('id_skripsi' => $id))->result();
        foreach ($dskripsi as $ds) {
            $email = $ds->email;
        }
        if ($cek > 00) {
            if ($this->db->update($this->table, ['status' => "0"], $kondisi)) {
                $isi_email = '
                    <p>Seminar akhir / skripsi anda ditolak</p>
                    ';
                $this->emailm->send('Seminar Akhir Ditolak', $email, $isi_email);

                $hasil = [
                    'error' => false,
                    'message' => "skripsi batal disetujui"
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }



	public function details($id)
	{


		$dosen = $this->session->userdata('id');


		$this->db->select('
		skripsi.id,
        skripsi.file_skripsi AS bukti,
        skripsi.sk_tim,
        skripsi.bukti_konsultasi,
        skripsi.revisi,
        skripsi.btp,
        skripsi.htp,
        skripsi.bsnp,
        skripsi.loa,
        skripsi.persetujuan,
        skripsi.file_skripsi,
        skripsi.tanggal,
        skripsi.jam,
        skripsi.tempat,
		skripsi.judul_skripsi as proposal_mahasiswa_judul,
		proposal_mahasiswa.dosen_id         as dosen1,
		proposal_mahasiswa.dosen2_id        as dosen2,
		proposal_mahasiswa.dosen_penguji_id as dosen3,
		dosen.nama as dosen_penguji,
		mahasiswa.id as mahasiswa_id,
		mahasiswa.nama as mahasiswa_nama,
		mahasiswa.email
	');

	$this->db->from($this->table);
	$this->db->join('proposal_mahasiswa', 'proposal_mahasiswa.id = skripsi.proposal_mahasiswa_id', 'left');
    $this->db->join('mahasiswa', 'mahasiswa.id = skripsi.mahasiswa_id', 'left');
	$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
	$this->db->join('hasil_skripsi', 'hasil_skripsi.seminar_id = skripsi.id', 'left');
	$this->db->where('skripsi.id', $id);		

	$penelitian = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($penelitian) ? false : true,
			'message' => ($penelitian) ? "data berhasil ditemukan" : "data tidak ditemukan",
			'data' => $penelitian
		];

		if ($hasil['data']) {
			$hasil['data']['hasil'] = $this->db->get_where('hasil_skripsi', ['seminar_id' => $hasil['data']['id']])->row_array();
     	}

		return $hasil;
	}



	public function edit3($input, $seminar_id)
	{

		$data = [
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];


		$validation = $this->app->validate($data);


		if ($validation === true) {

			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}


		return $hasil;
	}	




}

/* End of file skripsi_model.php */
/* Location: ./application/models/skripsi_model.php */