<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Seminar_model extends CI_Model
{

	protected $table = "seminar";


    public function getHeaderBeritaAcara($seminar_id)
    {
        $this->db->select("
			b.tanggal,
			b.jam,
            e.nama AS nama_mahasiswa,
            e.nim,
            c.judul AS proposal_mahasiswa_judul,
			c.ket,
			c.nama_pembimbing as dosen1,
            c.nama_pembimbing2 as dosen2,
            c.nama_penguji as dosen3,
            d.id AS dosen_id,
            d.nama AS nama_dosen,
            d.nip,
            d.jenis_jabatan,

            f.masukan1, f.masukan2, f.masukan3,
            f.nilai1, f.nilai2, f.nilai3,

            IF(
                d.id = c.dosen_id, f.masukan1,
                IF(d.id = c.dosen2_id, f.masukan2, f.masukan3)
            ) AS masukan,

            IF(
                d.id = c.dosen_id, f.nilai1,
                IF(d.id = c.dosen2_id, f.nilai2, f.nilai3)
            ) AS nilai,

            IF(
                d.jenis_jabatan = '1', 'Lektor',
                IF(d.jenis_jabatan = '2', 'AA', 'Tenaga Pendidik')
            ) AS jabatan,

            a.file_ttd
        ", false);

        $this->db->from('ttd_dosen a');
        $this->db->join('seminar b', 'a.seminar_id = b.id', 'left');
        $this->db->join('proposal_mahasiswa_v c', 'b.proposal_mahasiswa_id = c.id', 'left');
        $this->db->join('dosen d', 'a.dosen_id = d.id', 'left');
        $this->db->join('mahasiswa e', 'c.mahasiswa_id = e.id', 'left');
        $this->db->join('hasil_seminar f', 'b.id = f.seminar_id', 'left');

        $this->db->where('a.seminar_id', $seminar_id);
        $this->db->order_by('a.id', 'ASC');

        return $this->db->get()->result_array();
    }

public function get_ttd_dosen($seminar_id)
{
    $this->db->select('t.dosen_id, t.file_ttd, d.nama, d.jenis_jabatan, h.masukan, h.nilai1, h.nilai2, h.nilai3');
    $this->db->from('ttd_dosen t');
    $this->db->join('dosen d', 't.dosen_id = d.id', 'left');
    $this->db->join('hasil_seminar h', 't.seminar_id = h.seminar_id', 'left');
    $this->db->where('t.seminar_id', $seminar_id);
    $this->db->order_by('t.id', 'ASC'); // urut berdasarkan tanda tangan dibuat
    $ttd_list = $this->db->get()->result_array();

    // konversi jenis_jabatan ke teks
    foreach ($ttd_list as &$dosen) {
        switch ($dosen['jenis_jabatan']) {
            case '1':
                $dosen['jabatan'] = 'Lektor';
                break;
            case '2':
                $dosen['jabatan'] = 'AA';
                break;
            case '3':
                $dosen['jabatan'] = 'Tenaga Pendidik';
                break;
            default:
                $dosen['jabatan'] = '';
        }
    }

    return $ttd_list;
}



public function get_berita_acara($seminar_id)
{
    return $this->db->query("
        SELECT 
            e.nama AS nama_mahasiswa,
            e.nim,
            c.judul AS proposal_mahasiswa_judul,

            d.id AS id_dosen,
            d.nama AS nama_dosen,
            d.nip,
            IF(d.jenis_jabatan = '1', 'Lektor',
               IF(d.jenis_jabatan = '2', 'AA', 'Tenaga Pendidik')) AS jabatan,

            IF(d.id = c.dosen_id, f.masukan1,
               IF(d.id = c.dosen2_id, f.masukan2, f.masukan3)) AS masukan,

            IF(d.id = c.dosen_id, f.nilai1,
               IF(d.id = c.dosen2_id, f.nilai2, f.nilai3)) AS nilai,

            a.file_ttd,
            b.tanggal,
            b.jam,
            c.ket
        FROM ttd_dosen a
        JOIN seminar b ON a.seminar_id = b.id
        JOIN proposal_mahasiswa_v c ON b.proposal_mahasiswa_id = c.id
        JOIN dosen d ON a.dosen_id = d.id
        JOIN mahasiswa e ON c.mahasiswa_id = e.id
        JOIN hasil_seminar f ON b.id = f.seminar_id
        WHERE a.seminar_id = ?
        ORDER BY a.id ASC
    ", [$seminar_id])->result_array();
}


public function get_berita($seminar_id)
{
    // Gunakan view proposal_mahasiswa_v
    $sql = "SELECT s.id,
                   s.tanggal,
                   s.jam,
                   pm.nama_mahasiswa,
                   pm.nim,
                   pm.judul AS proposal_mahasiswa_judul,
				   h.nilai1, h.nilai2, h.nilai3,
                   h.masukan1, h.masukan2, h.masukan3,
				   pm.nama_pembimbing as nama_pembimbing1,
            	   pm.nama_pembimbing2 as nama_pembimbing2,
            	   pm.nama_penguji as nama_penguji,				   
                   pm.dosen1 AS dosen1,
                   pm.dosen2 AS dosen2,
                   pm.dosen3 AS dosen3
            FROM seminar s
            LEFT JOIN proposal_mahasiswa_v pm ON s.proposal_mahasiswa_id = pm.id
            LEFT JOIN hasil_seminar h ON s.id = h.seminar_id
            WHERE s.id = ?";

    $rs = $this->db->query($sql, [$seminar_id])->row_array();

    if (!$rs) return null;

    // Ambil tanda tangan dari ttd_dosen
    $ttd = $this->db->get_where('ttd_dosen', ['seminar_id' => $seminar_id])->result_array();

    $rs['ttd1'] = $rs['ttd2'] = $rs['ttd3'] = '';
    foreach ($ttd as $item) {
        if ($item['dosen_id'] == $rs['dosen1']) $rs['ttd1'] = $item['file_ttd'];
        if ($item['dosen_id'] == $rs['dosen2']) $rs['ttd2'] = $item['file_ttd'];
        if ($item['dosen_id'] == $rs['dosen3']) $rs['ttd3'] = $item['file_ttd'];
    }

    return $rs;
}


	function get_ta($id){
		$sql = "SELECT cl.id,
			cl.id,
			cl.file_skripsi,
			cl.bukti_konsultasi,
			cl.persetujuan,
			cl.sk_tim,
			cl.jadwal_skripsi AS tanggal,
			DATEDIFF(cl.jadwal_skripsi, CURDATE()) AS selisih,
			TIME(cl.jadwal_skripsi) AS jam,			
			kc.judul_skripsi,
			kc.nama_mahasiswa,
			kc.nim,
			kc.nama_prodi,
			IF(kc.status='1','Lulus','Tidak Lulus') AS ket,

			k.masukan1, k.masukan2, k.masukan3,
			IF((k.status = 1),'Hasil Sidang DITERIMA, tanpa Perbaikan',IF((k.status = 2),'Hasil Sidang DITERIMA, dengan Perbaikan','Hasil Sidang tidak DITERIMA, Ujian Ulang')) AS ket1,

			k.status AS hasil_seminar_status, k.nilai1, k.nilai2, k.nilai3, do1.nama AS dosen1, do2.nama AS dosen2, do3.nama AS dosen3
				FROM skripsi cl 
				LEFT JOIN hasil_skripsi k ON (cl.id = k.seminar_id)
                LEFT JOIN skripsi_v kc ON (kc.id_skripsi = cl.id)
				LEFT JOIN dosen do1 ON (kc.dosen_id = do1.id)
				LEFT JOIN dosen do2 ON (kc.dosen2_id = do2.id)
				LEFT JOIN dosen do3 ON (kc.dosen_penguji_id = do3.id)
				WHERE cl.id = '$id'";
		return $this->db->query($sql)->row();
	}

	function get_etik($id){
		$sql = "SELECT cl.*, do1.nama AS dosen1, do2.nama AS dosen2
				FROM hasil_kegiatan cl
				LEFT JOIN dosen do1 ON (cl.dosen_id = do1.id)
				LEFT JOIN dosen do2 ON (cl.dosen2_id = do2.id)
				WHERE cl.id = '$id'";
		return $this->db->query($sql)->row();
	}	


  function get_seminar($id)
  {
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			substr(proposal_mahasiswa_v.judul,1,100) as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->where('seminar.id', $id);
		
    $query = $this->db->get();
    return $query->result();
  }
  	


	public function view_all(){

		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			skripsi.jadwal_skripsi as tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			skripsi.judul_skripsi as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			if(proposal_mahasiswa_v.jenis_skripsi=1,"Skripsi&nbspKonvensional",if(proposal_mahasiswa_v.jenis_skripsi=2,"Sistematik&nbspReview","Case&nbspReport")) as ket,
			hasil_seminar.nilai1,
			hasil_seminar.nilai2,
			hasil_seminar.nilai3,
			hasil_skripsi.nilai1 as nilaia,
			hasil_skripsi.nilai2 as nilaib,
			hasil_skripsi.nilai3 as nilaic,			
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->join('skripsi', 'skripsi.mahasiswa_id = proposal_mahasiswa_v.mahasiswa_id', 'left');
		$this->db->join('hasil_skripsi', 'hasil_skripsi.seminar_id = skripsi.id', 'left');
		
		
		$query = $this->db->get();
		
        return $query->result();
		
	}
	
    public function view_by_date($tgl_awal, $tgl_akhir){
        $tgl_awal = $this->db->escape($tgl_awal);
        $tgl_akhir = $this->db->escape($tgl_akhir);
		
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			skripsi.jadwal_skripsi as tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			skripsi.judul_skripsi as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			if(proposal_mahasiswa_v.jenis_skripsi=1,"Skripsi&nbspKonvensional",if(proposal_mahasiswa_v.jenis_skripsi=2,"Sistematik&nbspReview","Case&nbspReport")) as ket,
			hasil_seminar.nilai1,
			hasil_seminar.nilai2,
			hasil_seminar.nilai3,
			hasil_skripsi.nilai1 as nilaia,
			hasil_skripsi.nilai2 as nilaib,
			hasil_skripsi.nilai3 as nilaic,				
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->join('skripsi', 'skripsi.mahasiswa_id = proposal_mahasiswa_v.mahasiswa_id', 'left');
		$this->db->join('hasil_skripsi', 'hasil_skripsi.seminar_id = skripsi.id', 'left');	
		
		
        $this->db->where('DATE(skripsi.jadwal_skripsi) BETWEEN '.$tgl_awal.' AND '.$tgl_akhir); // Tambahkan where tanggal nya
		
		$query = $this->db->get();
		
    return $query->result();
	}
  
  
  
  function get_all()
  {
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			proposal_mahasiswa_v.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_prodi,
			hasil_seminar.status as hasil_seminar_status
		');

		$this->db->from($this->table);
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->join('proposal_mahasiswa_v', 'proposal_mahasiswa_v.id = seminar.proposal_mahasiswa_id', 'left');
    $query = $this->db->get();
    return $query->result();
  }





    // ===== INDEX =====
public function index($input)
{
    $this->db->select('
      s.id,
      s.tanggal,
      s.jam,
      s.tempat,

      p.judul as proposal_mahasiswa_judul,
	  p.mahasiswa_id,
      p.nama_mahasiswa,
      p.nim,
      p.nama_prodi,
      p.nama_pembimbing,
      p.nama_pembimbing2,
      p.nama_penguji,

      hs.status AS hasil_seminar_status
    ');

    $this->db->from('seminar_v s');
    $this->db->join('proposal_mahasiswa_base_v p', 'p.id = s.proposal_mahasiswa_id', 'left');
    $this->db->join('hasil_seminar_v hs', 'hs.seminar_id = s.id', 'left');

    if (!empty($input['mahasiswa_id'])) {
        $this->db->where('p.mahasiswa_id', $input['mahasiswa_id']);
    }

    if (!empty($input['dosen_id'])) {
        $this->db->group_start();
        $this->db->where('p.dosen_id', $input['dosen_id']);
        $this->db->or_where('p.dosen2_id', $input['dosen_id']);
        $this->db->or_where('p.dosen_penguji_id', $input['dosen_id']);
        $this->db->group_end();
    }

    $seminar = $this->db->get()->result_array();

    return [
        'error' => false,
        'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
        'data' => $seminar
    ];
}



	public function create($input)
	{
		$data = [
			'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {
			$file_nama = date('Ymdhis') . '.pdf';

			$this->db->insert($this->table, $data);
			$data_id = $this->db->insert_id();
			$this->db->insert("hasil_seminar", [
				'seminar_id' => $data_id,
				'berita_acara' => "",
				'masukan1' => "",
				'masukan2' => "",
				'masukan3' => "",
				'status' => '0'
			]);

			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambahkan",
				'data_id' => $data_id
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}


	public function edit2($input, $seminar_id)
	{

		$data = [
			'dosen_penguji_id' => $input['dosen3'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];


		$validation = $this->app->validate($data);

		if ($validation === true) {

			if ($input['file_3A2']) {
				$file_3A2_file = explode(';base64,', $input['file_3A2'])[1];
				$file_3A2_nama = date('Ymdhis') . '.pdf';
				file_put_contents(FCPATH . 'cdn/vendor/file_3A2/' . $file_3A2_nama, base64_decode($file_3A2_file));
				$data['file_3A2'] = $file_3A2_nama;
			}


			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}

		return $hasil;
	}	

	public function edit3($input, $seminar_id)
	{

		$data = [
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat']
		];


		$validation = $this->app->validate($data);


		if ($validation === true) {

			if ($this->db->update($this->table, $data, ['id' => $seminar_id])) {
		
				$hasil = [
					'error' => false,
					'message' => "data berhasil diedit"
				];
			}
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}


		return $hasil;
	}	

	public function create1($input)
	{
		$data = [
			'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
			'tanggal' => $input['tanggal'],
			'jam' => $input['jam'],
			'tempat' => $input['tempat'],
			'file_3A2' => $input['file_3A2']
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {
			$file_nama = date('Ymdhis') . '.pdf';

			// upload base64 file_proposal

			
			$file_3A2_file = explode(';base64,', $data['file_3A2'])[1];
			file_put_contents(FCPATH . 'cdn/vendor/file_3A2/' . $file_nama, base64_decode($file_3A2_file));
			$data['file_3A2'] = $file_nama;
			


			$this->db->insert($this->table, $data);
			$data_id = $this->db->insert_id();
			$this->db->insert("hasil_seminar", [
				'seminar_id' => $data_id,
				'berita_acara' => "",
				'masukan' => "",
				'status' => '3'
			]);

			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambahkan",
				'data_id' => $data_id
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}

	public function details($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			seminar.id,
			seminar.proposal_mahasiswa_id,
			seminar.tanggal,
			seminar.jam,
			seminar.tempat,

			seminar.file_proposal,
			seminar.file_proposal,
			seminar.bukti_konsultasi,
			seminar.persetujuan,
			seminar.sk_tim,
			seminar.file_3A1,
			seminar.file_3A2,			

			proposal_mahasiswa.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa.dosen_id         as dosen1,
			proposal_mahasiswa.dosen2_id        as dosen2,
			proposal_mahasiswa.dosen_penguji_id as dosen3,
			dosen.nama as dosen_penguji,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email
		');

		$this->db->from($this->table);
		$this->db->join('proposal_mahasiswa', 'proposal_mahasiswa.id = seminar.proposal_mahasiswa_id', 'left');
		$this->db->join('mahasiswa', 'mahasiswa.id = proposal_mahasiswa.mahasiswa_id', 'left');
		$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
		$this->db->join('hasil_seminar', 'hasil_seminar.seminar_id = seminar.id', 'left');
		$this->db->where('seminar.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar
		];

		if ($hasil['data']) {
			$hasil['data']['hasil'] = $this->db->get_where('hasil_seminar', ['seminar_id' => $hasil['data']['id']])->row_array();
		}

		return $hasil;
	}

	public function destroy($id)
	{

		$kondisi = [
			'id' => $id
		];

		$seminar = $this->db->get_where($this->table, $kondisi)->row_array();

		if ($seminar) {
			
			$this->db->delete("hasil_seminar", ['seminar_id' => $id]);


			$this->db->delete($this->table, $kondisi);
			$hasil = [
				'error' => false,
				'message' => "data berhasil dihapus"
			];
		} else {
			$hasil = [
				'error' => true,
				'message' => "data tidak ditemukan"
			];
		}

		return $hasil;
	}
}

/* End of file Seminar_model.php */
/* Location: ./application/models/Seminar_model.php */