<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Revisi_model extends CI_Model
{

	protected $table = "revisi";


    public function index($input)
    {

        $this->db->select('
			revisi.id,
			revisi.proposal_mahasiswa_id,
			revisi.bukti,
			revisi.status,
			proposal_mahasiswa_v.dosen_id         as dosen1,
			proposal_mahasiswa_v.dosen2_id        as dosen2,
			proposal_mahasiswa_v.dosen_penguji_id as dosen3,
			
			proposal_mahasiswa_v.nama_pembimbing as nama_pembimbing,
			proposal_mahasiswa_v.nama_pembimbing2 as nama_pembimbing2,
			proposal_mahasiswa_v.nama_penguji as nama_penguji,			
						
			proposal_mahasiswa_v.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa_v.nim,
			proposal_mahasiswa_v.nama_mahasiswa,
			proposal_mahasiswa_v.nama_prodi
        ');
        $this->db->from('revisi');
        $this->db->join(
            'proposal_mahasiswa_v',
            'proposal_mahasiswa_v.id = revisi.proposal_mahasiswa_id',
            'INNER'
        );
 
        if (!empty($input['mahasiswa_id'])) {
            $this->db->where(
                'proposal_mahasiswa_v.mahasiswa_id',
                $input['mahasiswa_id']
            );
        }

        if (!empty($input['dosen_id'])) {
            $this->db->where(
                'proposal_mahasiswa_v.dosen_id',
                $input['dosen_id']
            );
            $this->db->or_where(
                'proposal_mahasiswa_v.dosen2_id',
                $input['dosen_id']
            );
            $this->db->or_where(
                'proposal_mahasiswa_v.dosen_penguji_id',
                $input['dosen_id']
            );			
        }


        $revisi = $this->db->get()->result_array();

        $hasil['error'] = false;
        $hasil['message'] = ($revisi) ? "data berhasil ditemukan" : "data tidak tersedia";
        $hasil['data'] = $revisi;

        return $hasil;
    }


	public function create($input)
	{
		$data = [
			'proposal_mahasiswa_id' => $input['proposal_mahasiswa_id'],
			'bukti' => $input['bukti'],
			'persetujuan_pembimbing' => '2',
			'persetujuan_penguji' => '2'
		];

		$validation = $this->app->validate($data);

		if ($validation === true) {

			$bukti_file = explode(';base64,', $data['bukti'])[1];
			$bukti_nama = date('Ymdhis') . '.pdf';
			file_put_contents(FCPATH . 'cdn/vendor/revisi/' . $bukti_nama, base64_decode($bukti_file));
			$data['bukti'] = $bukti_nama;


			$this->db->insert($this->table, $data);
			$data_id = $this->db->insert_id();

			$this->db->insert('hasil_revisi', [
				'penelitian_id' => $data_id,
				'status' => "2"
			]);

			$hasil = [
				'error' => false,
				'message' => "data berhasil ditambah"
			];
		} else {
			$hasil = $validation;
		}

		return $hasil;
	}

	public function destroy($id)
	{
		$kondisi = [
			'id' => $id
		];

		$penelitian = $this->db->get_where($this->table, ['id' => $id])->row_array();

		unlink(FCPATH . 'cdn/vendor/revisi/' . $penelitian['bukti']);


		$this->db->delete("hasil_revisi", ['penelitian_id' => $id]);
		$this->db->delete($this->table, ['id' => $id]);

		$hasil = [
			'error' => false,
			'message' => "data berhasil dihapus"
		];

		return $hasil;
	}

	public function details($id)
	{


		$dosen = $this->session->userdata('id');


		$this->db->select('
		revisi.id,
		revisi.proposal_mahasiswa_id,
		revisi.bukti,
		proposal_mahasiswa.judul as proposal_mahasiswa_judul,
		proposal_mahasiswa.dosen_id         as dosen1,
		proposal_mahasiswa.dosen2_id        as dosen2,
		proposal_mahasiswa.dosen_penguji_id as dosen3,
		dosen.nama as dosen_penguji,
		mahasiswa.id as mahasiswa_id,
		mahasiswa.nama as mahasiswa_nama,
		mahasiswa.email
	');

	$this->db->from($this->table);
	$this->db->join('proposal_mahasiswa', 'proposal_mahasiswa.id = revisi.proposal_mahasiswa_id', 'left');
	$this->db->join('mahasiswa', 'mahasiswa.id = proposal_mahasiswa.mahasiswa_id', 'left');
	$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
	$this->db->join('hasil_revisi', 'hasil_revisi.penelitian_id = revisi.id', 'left');
	$this->db->where('revisi.id', $id);		

	$penelitian = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($penelitian) ? false : true,
			'message' => ($penelitian) ? "data berhasil ditemukan" : "data tidak ditemukan",
			'data' => $penelitian
		];

		if ($hasil['data']) {
			$hasil['data']['proposal'] = $this->db->get_where('proposal_mahasiswa_v', ['id' => $hasil['data']['proposal_mahasiswa_id']])->row_array();
			$hasil['data']['hasil'] = $this->db->get_where('hasil_revisi', ['penelitian_id' => $hasil['data']['id']])->row_array();
     	}

		return $hasil;
	}



	public function details1($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			revisi.id,
			revisi.proposal_mahasiswa_id,
			revisi.bukti,
			hasil_revisi.masukan1,
			hasil_revisi.masukan2,
			hasil_revisi.masukan3,
			proposal_mahasiswa.judul as proposal_mahasiswa_judul,
			proposal_mahasiswa.dosen_id         as dosen1,
			proposal_mahasiswa.dosen2_id        as dosen2,
			proposal_mahasiswa.dosen_penguji_id as dosen3,
			dosen.nama as dosen_penguji,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email
		');

		$this->db->from($this->table);
		$this->db->join('proposal_mahasiswa', 'proposal_mahasiswa.id = revisi.proposal_mahasiswa_id', 'left');
		$this->db->join('mahasiswa', 'mahasiswa.id = proposal_mahasiswa.mahasiswa_id', 'left');
		$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
		$this->db->join('hasil_revisi', 'hasil_revisi.penelitian_id = revisi.id', 'left');
		$this->db->where('revisi.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan" : "data tidak tersedia",
			'data' => $seminar
		];

		if ($hasil['data']) {
			$hasil['data']['hasil'] = $this->db->get_where('hasil_revisi', ['penelitian_id' => $hasil['data']['id']])->row_array();
		}

		return $hasil;
	}



    public function agree($id)
    {
        $kondisi = ['revisi.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        if ($cek > 00) {
            $dataUpdate = array(
                'status' => '1'
            );

            if ($this->db->update($this->table, $dataUpdate, $kondisi)) {
				$hasil = [
                    'error' => false,
                    'message' => "Revisi Proposal berhasil disetujui",
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }

    public function disagree($id)
    {
        $kondisi = ['revisi.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi);

        if ($cek > 00) {

            if ($this->db->update($this->table, ['status' => "0"], $kondisi)) {
                $hasil = [
                    'error' => false,
                    'message' => "Revisi Proposal batal disetujui"
                ];
            }
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }




}

/* End of file Penelitian_model.php */
/* Location: ./application/models/Penelitian_model.php */