<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Proposal_mahasiswa_model extends CI_Model
{
    protected $table = "proposal_mahasiswa";

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Email_model', 'emailm');
        
    }

    public function cari_data($keyword = null) {
        if($keyword){
            $this->db->like('mahasiswa_id', $keyword);
        }
        $query = $this->db->get($this->table);
        return $query->result();
    }

    public function get_files($id_user = null, $id_gol = null) {
        if($id_user) $this->db->where('mahasiswa_id', $id_user);
        if($id_gol) $this->db->where('status', $id_gol);
        $query = $this->db->get($this->table);
        return $query->result();
    }

    public function get($input = [])
    {
        $kondisi = [];
        $kondisi1 = [];
        $kondisi2 = [];

        $dosen_id = $input['dosen_id'] ?? null;
        if($dosen_id){
            $kondisi['proposal_mahasiswa.dosen_id'] = $dosen_id;
            $kondisi1['proposal_mahasiswa.dosen2_id'] = $dosen_id;
            $kondisi2['proposal_mahasiswa.dosen_penguji_id'] = $dosen_id;
        }

        $status = $input['status'] ?? null;
        if($status) $kondisi['status'] = $status;

        $mahasiswa_id = $input['mahasiswa_id'] ?? null;
        if($mahasiswa_id) $kondisi['mahasiswa_id'] = $mahasiswa_id;

        $this->db->select("*");
        if($kondisi){
            $this->db->group_start();
            $this->db->where($kondisi);
            $this->db->or_where($kondisi1);
            $this->db->or_where($kondisi2);
            $this->db->group_end();
        }

        $proposal_mahasiswa = $this->db->get($this->table)->result_array();

        $hasil = [
            'error' => false,
            'message' => $proposal_mahasiswa ? "data berhasil ditemukan22222" : "data tidak tersedia",
            'data' => $proposal_mahasiswa
        ];

        foreach ($proposal_mahasiswa as $key => $item) {
            $hasil['data'][$key]['mahasiswa'] = $this->db->get_where('mahasiswa_v', ['id' => $item['mahasiswa_id']])->row_array() ?? [];
            $hasil['data'][$key]['pembimbing'] = $this->db->get_where('dosen', ['id' => $item['dosen_id']])->row_array() ?? [];
            $hasil['data'][$key]['pembimbing2'] = $this->db->get_where('dosen', ['id' => $item['dosen2_id']])->row_array() ?? [];
            $hasil['data'][$key]['penguji'] = ($item['dosen_penguji_id'] ?? 0) ? $this->db->get_where('dosen', ['id' => $item['dosen_penguji_id']])->row_array() : [];
        }

        return $hasil;
    }

    public function create($input)
    {
        $data = [
            'mahasiswa_id' => $input['mahasiswa_id'] ?? null,
            'judul' => $input['judul'] ?? null,
            'ringkasan' => $input['ringkasan'] ?? null,
            'dosen_id' => $input['dosen_id'] ?? null,
            'dosen2_id' => $input['dosen2_id'] ?? null,
            'jenis_skripsi' => $input['jenis_skripsi'] ?? null            
        ];

        $validate = $this->app->validate($data);

        if ($validate === true) {
            $this->db->insert($this->table, $data);
            $data_id = $this->db->insert_id();
            return ['error' => false, 'message' => "data berhasil ditambah", 'data_id' => $data_id];
        }
        return $validate;
    }

    public function update($input, $id)
    {
        $data = [
            'mahasiswa_id' => $input['mahasiswa_id'] ?? null,
            'judul' => $input['judul'] ?? null,
            'ringkasan' => $input['ringkasan'] ?? null,
            'dosen_id' => $input['dosen_id'] ?? null,
            'dosen2_id' => $input['dosen2_id'] ?? null,
            'dosen_penguji_id' => $input['dosen_penguji_id'] ?? null,            
            'jenis_skripsi' => $input['jenis_skripsi'] ?? null
        ];

        $kondisi = ['id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi)->num_rows();

        if ($cek > 0) {
            $validate = $this->app->validate($data);
            if ($validate === true) {
                $this->db->update($this->table, $data, $kondisi);
                return ['error' => false, 'message' => "data berhasil diedit"];
            }
            return $validate;
        }

        return ['error' => true, 'message' => "data tidak ditemukan"];
    }


	public function details($id)
	{
		
		$dosen = $this->session->userdata('id');
		
		$this->db->select('
			proposal_mahasiswa.judul as proposal_mahasiswa_judul,
            proposal_mahasiswa.ringkasan,
            proposal_mahasiswa.jenis_skripsi,
            proposal_mahasiswa.file_3A2,
			proposal_mahasiswa.dosen_id         as dosen1,
			proposal_mahasiswa.dosen2_id        as dosen2,
			proposal_mahasiswa.dosen_penguji_id as dosen3,
			dosen.nama as dosen_penguji,
			mahasiswa.id as mahasiswa_id,
			mahasiswa.nama as mahasiswa_nama,
			mahasiswa.email
		');

		$this->db->from($this->table);
		$this->db->join('mahasiswa', 'mahasiswa.id = proposal_mahasiswa.mahasiswa_id', 'left');
		$this->db->join('dosen', 'dosen.id = proposal_mahasiswa.dosen_penguji_id', 'left');
		$this->db->where('proposal_mahasiswa.id', $id);

		$seminar = $this->db->get()->row_array();

		$hasil = [
			'dosen' => $dosen,
			'error' => ($seminar) ? false : true,
			'message' => ($seminar) ? "data berhasil ditemukan123" : "data tidak tersedia",
			'data' => $seminar
		];


		return $hasil;
	}



    public function edit2($input, $files, $seminar_id){

        if (empty($files['file_3A2']) || empty($files['file_3A2']['name'])) {
            return [
                'error' => true,
                'message' => 'File upload wajib diisi'
            ];
        }


        if(!$seminar_id){
            return ['error'=>true,'message'=>'ID tidak valid'];
        }

        $old = $this->db
            ->get_where($this->table,['id'=>$seminar_id])
            ->row();

        $data = [];

        if(!empty($files['file_3A2']['name'])){

            if($files['file_3A2']['size'] > 50 * 1024 * 1024){
                return ['error'=>true,'message'=>'File maksimal 50MB'];
            }

            $config['upload_path']   = FCPATH.'cdn/vendor/file_3A2/';
            $config['allowed_types'] = 'pdf';
            $config['max_size']      = 51200;
            $config['file_name']     = 'FORM3A_'.time();

            $this->load->library('upload',$config);

            if(!$this->upload->do_upload('file_3A2')){
                return [
                    'error'=>true,
                    'message'=>strip_tags($this->upload->display_errors())
                ];
            }

            $upload = $this->upload->data();
            $data['file_3A2'] = $upload['file_name'];

            // hapus file lama
            if($old && $old->file_3A2){
                $path = FCPATH.'cdn/vendor/file_3A2/'.$old->file_3A2;
                if(file_exists($path)) unlink($path);
            }
        }

        $this->db->update($this->table,$data,['id'=>$seminar_id]);

        return [
            'error'=>false,
            'message'=>'Form 3A berhasil diperbarui'
        ];
    }    




public function edit3($input, $seminar_id)
{
    // Ambil data lama (khusus dosen penguji)
    $lama = $this->db
        ->select('dosen_penguji_id')
        ->get_where($this->table, ['id' => $seminar_id])
        ->row_array();

    $data = [
        'judul'             => $input['proposal_mahasiswa_judul'] ?? null,
        'ringkasan'         => $input['ringkasan'] ?? null,
        'jenis_skripsi'     => $input['jenis_skripsi'] ?? null,
        'dosen_id'          => $input['dosen_id'] ?? null,
        'dosen2_id'         => $input['dosen2_id'] ?? null,
        'dosen_penguji_id'  => $input['dosen_penguji_id'] ?? null,
    ];


    $this->db->where('id', $seminar_id);
    $update = $this->db->update($this->table, $data);

    if ($update) {
        return [
            'error' => false,
            'message' => 'Data berhasil disimpan'
        ];
    }

    return [
        'error' => true,
        'message' => 'Gagal menyimpan data'
    ];
}


    public function destroy($id)
    {

		// hapus folder file_proposal

		$id_user	= $this->session->userdata('id');

		$kondisi = [
			'id_user' => $id_user
		];

		$hasil_foto = $this->db->get_where('foto', ['id_user' => $id_user])->result_array();

			foreach ($hasil_foto as $key => $item) {
				if ($item['nama_foto']) {
					unlink(FCPATH . 'cdn/vendor/file_proposal/' . $item['nama_foto']);
				}
			}

		$this->db->delete("foto", ['id_user' => $id_user]);

		// end hapus folder file_proposal

        $kondisi = ['proposal_mahasiswa.id' => $id];
        $cek = $this->db->get_where($this->table, $kondisi)->num_rows();

        if ($cek > 0) {


		    $hasil_foto = $this->db->get_where('proposal_mahasiswa', ['id' => $id])->result_array();

			foreach ($hasil_foto as $key => $item) {
				if ($item['file_3A2']) {
					unlink(FCPATH . 'cdn/vendor/file_3A2/' . $item['file_3A2']);
				}
			}


            $this->db->delete($this->table, $kondisi);
            $hasil = [
                'error' => false,
                'message' => "data berhasil dihapus"
            ];
        } else {
            $hasil = [
                'error' => true,
                'message' => "data tidak ditemukan"
            ];
        }

        return $hasil;
    }


public function agree($id, $deadline)
{
    // cek data proposal
    $kondisi = ['proposal_mahasiswa.id' => $id];
    $cek = $this->db->get_where('proposal_mahasiswa', ['id' => $id]);

    if ($cek->num_rows() == 0) {
        return [
            'error' => true,
            'message' => 'Data proposal tidak ditemukan'
        ];
    }

    $row = $cek->row();

    // VALIDASI WAJIB
    if ((int)$row->dosen_penguji_id == 0) {
        return [
            'error' => true,
            'message' => 'Dosen penguji belum ditentukan'
        ];
    }

    if (empty($row->file_3A2)) {
        return [
            'error' => true,
            'message' => 'File 3A wajib diupload sebelum disetujui'
        ];
    }

    // ambil email mahasiswa
    $email = '';
    $dProposal = $this->db
        ->get_where('proposal_mahasiswa_v', ['id' => $id])
        ->row();

    if ($dProposal) {
        $email = $dProposal->email;
    }



            if ($this->db->update($this->table, ['status' => "1", 'deadline' => $deadline], $kondisi)) {

                $isi_email = '
                    <p>Usulan proposal anda telah disetujui, silahkan lanjut ke tahap berikutnya.</p>
                    ';
                $this->emailm->send('Usulan Proposal Disetujui', $email, $isi_email);

                return [
                    'error' => false,
                    'message' => 'Proposal berhasil disetujui'
                ];

            }

}


public function disagree($id)
{
    // cek data proposal
    $kondisi = ['proposal_mahasiswa.id' => $id];
    $cek = $this->db->get_where('proposal_mahasiswa', ['id' => $id]);

    if ($cek->num_rows() == 0) {
        return [
            'error' => true,
            'message' => 'Data proposal tidak ditemukan'
        ];
    }

    
    // ambil email mahasiswa
    $email = '';
    $dProposal = $this->db
        ->get_where('proposal_mahasiswa_v', ['id' => $id])
        ->row();

    if ($dProposal) {
        $email = $dProposal->email;
    }



            if ($this->db->update($this->table, ['status' => "0", 'deadline' => null], $kondisi)) {

                $isi_email = '
                    <p>Usulan proposal anda tidak disetujui, silahkan membenarkan usulan proposal anda.</p>
                    ';
                $this->emailm->send('Usulan Proposal Tidak Disetujui', $email, $isi_email);

                return [
                    'error' => false,
                    'message' => 'proposal batal disetujui'
                ];

            }

}



    // ======================== other methods (agree, disagree, edit2, edit3, details) ========================
    // Gunakan sama, pastikan semua array key pakai ?? null
}
