<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use Dompdf\Dompdf;
use Dompdf\Options;

class Pdf {

    protected $dompdf;

    public function __construct()
    {
        require_once APPPATH.'../vendor/autoload.php';

        $options = new Options();
        $options->set('isRemoteEnabled', true);
        $options->set('defaultFont', 'Times-Roman');

        $this->dompdf = new Dompdf($options);
    }

    /**
     * Generate PDF
     *
     * @param string $html      HTML content
     * @param string $filename  PDF filename
     * @param bool   $isFinal   TRUE jika semua tanda tangan lengkap → watermark RAHASIA
     */
    public function generate($html, $filename, $isFinal = false)
    {
        $this->dompdf->setPaper('A4', 'portrait');
        $this->dompdf->loadHtml($html);
        $this->dompdf->render();

        $canvas = $this->dompdf->getCanvas();
        $w = $canvas->get_width();
        $h = $canvas->get_height();


/* ==========================
   WATERMARK
   ========================== */
$text = $isFinal ? "RAHASIA" : "DRAFT";

// set ukuran font watermark
$fontSize = 80; // turunkan dari 100 agar tidak terpotong

// set posisi di tengah halaman
$x = $w / 2;
$y = $h / 2;

// opacity watermark
$opacity = 0.08;

// rotation 45 derajat
$canvas->page_script(function($pageNumber, $pageCount, $canvas, $fontMetrics) use ($text, $x, $y, $fontSize, $opacity) {
    $canvas->set_opacity($opacity);
    $canvas->text(
        $x - ($fontMetrics->getTextWidth($text, 'Times-Roman', $fontSize) / 2),
        $y,
        $text,
        'Times-Roman',
        $fontSize,
        [0,0,0],
        45
    );
    $canvas->set_opacity(1);
});


        /* ==========================
           ENCRYPT PDF (FINAL)
           ========================== */
        if ($isFinal) {
            $cpdf = $canvas->get_cpdf();
            $cpdf->setEncryption(
                null,
                'owner-kampus-2026', // password owner
                [] // kosong = tidak bisa edit/copy/print
            );
        }

        $this->dompdf->stream($filename, ['Attachment' => false]);
    }

    /**
     * Optional helper: Cek apakah semua dosen sudah tanda tangan
     *
     * @param array $ttd Array ttd, contoh: ['ttd1'=>file1, 'ttd2'=>file2, 'ttd3'=>file3]
     * @return bool TRUE jika semua sudah ada
     */
    public function allSigned($ttd)
    {
        return !empty($ttd['ttd1']) && !empty($ttd['ttd2']) && !empty($ttd['ttd3']);
    }
}
