<?php
defined('BASEPATH') OR exit('No direct script access allowed');

use Dompdf\Dompdf;
use Dompdf\Options;

class Pdf {

    protected $dompdf;

    public function __construct()
    {
        require_once APPPATH.'../vendor/autoload.php';

        $options = new Options();
        $options->set('isRemoteEnabled', true);
        $options->set('defaultFont', 'Times-Roman');

        $this->dompdf = new Dompdf($options);
    }

    /**
     * @param string $html     HTML konten PDF
     * @param string $filename Nama file PDF
     * @param bool   $isFinal  true = FINAL (RAHASIA & dikunci)
     */
    public function generate($html, $filename, $isFinal = false)
    {
        $this->dompdf->setPaper('A4', 'portrait');
        $this->dompdf->loadHtml($html);
        $this->dompdf->render();

        $canvas = $this->dompdf->getCanvas();
        $w = $canvas->get_width();
        $h = $canvas->get_height();

        // ==========================
        // WATERMARK
        // ==========================
        $text = $isFinal ? "RAHASIA" : "DRAFT";
        $fontSize = 80;        // ukuran font watermark
        $opacity = 0.08;       // transparansi
        $canvas->page_script(function($pageNumber, $pageCount, $canvas, $fontMetrics) use ($text, $w, $h, $fontSize, $opacity) {
            $x = $w / 2 - ($fontMetrics->getTextWidth($text, 'Times-Roman', $fontSize) / 2);
            $y = $h / 2;

            $canvas->set_opacity($opacity);
            $canvas->text($x, $y, $text, 'Times-Roman', $fontSize, [0,0,0], 45);
            $canvas->set_opacity(1);
        });

        // ==========================
        // KUNCI PDF (FINAL)
        // ==========================
        if ($isFinal) {
            $cpdf = $canvas->get_cpdf();
            $cpdf->setEncryption(
                null,
                'owner-kampus-2026',
                [] // kosong = tidak boleh edit/copy/print
            );
        }

        $this->dompdf->stream($filename, ['Attachment' => false]);
    }
}
