<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ttd extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->helper(['url','form']);
    }

    /**
     * Tampilkan form tanda tangan
     */
    public function index($id_seminar)
    {
        $data = [
            'id_seminar' => $id_seminar,
            'nama_dosen' => 'Dr. Ahmad, Sp.PD' // nanti ambil dari session/login
        ];

        $this->load->view('admin/tanda_tangan', $data);
    }

    /**
     * Simpan hasil tanda tangan
     */

public function simpan()
{
    if ($this->session->userdata('level') != 2) {
        show_error('Akses ditolak');
    }

    $image = $this->input->post('image');
    $seminar_id = $this->input->post('seminar_id');

    $dosen_id = $this->session->userdata('id');

    $image = str_replace('data:image/png;base64,', '', $image);
    $image = base64_decode($image);

    $filename = 'ttd_dosen'.$dosen_id.'_'.$seminar_id.'.png';

    $path = FCPATH.'assets/ttd/';
    if (!is_dir($path)) mkdir($path, 0777, true);

    file_put_contents($path.$filename, $image);

    echo json_encode([
        'status' => true,
        'file' => $filename
    ]);
}


}
