<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report6 extends MY_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('Seminar_model');
        $this->load->library('pdf');
    }


public function cetak($id)
{
    $rs = $this->Seminar_model->getHeaderBeritaAcara($id);

    if (empty($rs)) {
        show_error('Data tidak ditemukan');
    }

    // data umum diambil dari record pertama
    $first = $rs[0];

    $hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
    $namahari = $hari[ date('w', strtotime($first['tanggal'])) ];

    // hitung jumlah ttd
    $jumlah_ttd = count($rs);
    $isFinal = ($jumlah_ttd >= 3);

    $data = [
        'rs'        => $rs,
        'first'     => $first,
        'namahari'  => $namahari
    ];

    $html = $this->load->view('cetak/berita_acara_modern', $data, true);

    $this->pdf->generate(
        $html,
        'berita_acara_'.$id.'.pdf',
        $isFinal
    );
}


public function cetak_old($id)
{
    $rs = $this->Seminar_model->get_berita($id);
    if (is_object($rs)) $rs = (array) $rs;

    // nama hari
    $hari = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];
    $namahari = $hari[ date('w', strtotime($rs['tanggal'])) ];

    // cek jumlah TTD
    $jumlah_ttd = $this->db
        ->where('seminar_id', $id)
        ->count_all_results('ttd_dosen');

    $isFinal = ($jumlah_ttd >= 3); // WAJIB 3 DOSEN

    $data = [
        'rs' => $rs,
        'namahari' => $namahari
    ];

    $html = $this->load->view('cetak/berita_acara_modern', $data, true);

    $this->pdf->generate(
        $html,
        'berita_acara_'.$id.'.pdf',
        $isFinal
    );
}



}
