<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';
$route['admin'] = 'admin/dashboard';
$route['dosen'] = 'dosen/dashboard';
$route['mahasiswa'] = 'mahasiswa/dashboard';

$route['getData/(:any)'] = 'Crud/getData/$1';
$route['getAllData/(:any)'] = 'Crud/getAllData/$1';


$route['hasil-pencarian-mahasiswa'] = 'admin/mahasiswa/pencarian';
$route['lihat-selengkapnya/(:any)'] = 'admin/dosen/lihat_selengkapnya/$1';

$route['cekdeadline/(:num)'] = 'mahasiswa/Dashboard/cekdeadline/$1';
$route['getDeadline'] = 'mahasiswa/dashboard/getDeadline';

$route['atur-send-email'] = 'admin/pengaturan/atur_send_email';

// Home
$route['home-template'] = 'Home/home_template';
$route['update-home-template'] = 'Home/update_home_template';



$route['cari-proposal'] = 'mahasiswa/Seminar/index';


// Dropzone

$route['dropzone-upload-image'] = 'ImageController';
$route['dropzone-upload-image/post']['post'] = 'ImageController/uploadImage';
$route['remove_foto/post']['post'] = 'ImageController/remove_foto';
$route['dropzone-upload-image/get']['get'] = 'ImageController/readFiles';

$route['upload-skripsi/post']['post'] = 'ImageController/uploadSkripsi';
$route['remove_skripsi/post']['post'] = 'ImageController/remove_skripsi';
$route['dropzone-skripsi/get']['get'] = 'ImageController/readSkripsiFiles';

//


$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
